<?php

if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

class SocialFans_License {

    static protected $license_key_option = 'sfcounter_purchase_code';

    public static function activateLicense($code)
    {
        update_option(self::$license_key_option, $code);
    }

    public static function isPluginActiveted()
    {
        $license = get_option(self::$license_key_option);

        if($license)
            return true;

        return false;
    }

    public static function getPurchaseCode()
    {
        return get_option(self::$license_key_option);
    }

    public static function deactivtePlugin()
    {
        return delete_option(self::$license_key_option);
    }

}